
######################################################################
#
# Name:  calcSeqShotVersion
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This plugin calculates the sequence, shot and version from the scene file name
#   This script has to be modified for your pipeline
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################


jobFirst= rr.jobSelected_get(0)
folders= jobFirst.sceneName
folders= folders.replace("\\","/")  #win to linux
folders= folders.replace("//","/")  #remove first UNC double slash //fileserver
folders= folders.split("/")

sequenceName=""
shotName=""
versionName=""

if (False):
    #--------------------------------------------------------------------------------------
    #This example assumes that sequence/shot/version are folder names
    sequenceIndex= 6
    shotIndex= 7
    versionIndex= len(folders)-1
    #rrGlobal.writeLog(rrGlobal.logLvL.warning, "calcSeqShotVersion: "+ str(folders),"")
    #rrGlobal.writeLog(rrGlobal.logLvL.warning, "calcSeqShotVersion: "+ folders[sequenceIndex],"")
    if ( (len(folders)<=sequenceIndex) or (len(folders)<=shotIndex) or (len(folders)<=versionIndex)):
         #rrGlobal.writeLog(rrGlobal.logLvL.warning, "calcSeqShotVersion: Not enough folders!","")
         raise rrCleanExit()
    sequenceName= folders[sequenceIndex]
    sequenceName= sequenceName.replace("Sequence-","")
    shotName= folders[shotIndex]
    versionName= folders[versionIndex]
    if ".v" in versionName:
        pos= versionName.find(".v")+2
        versionName= versionName[pos:]
        pos= versionName.find(".")
        versionName= versionName[0:pos]
    else:
        versionName=""


if (True):
    #--------------------------------------------------------------------------------------
    #This example assumes that your scene folders are named like this:
    #\\fileserver\prj\work\sequences\NTL_102_080Z\NTL_102_080Z_170\FX\main\houdini\NTL_102_080Z_170_FX_main_v002.hip
    #                                    ^Seqnce^     ^Seqnce  ^shot                                        ^version   
    seqIdx=-1
    for idx in range(len(folders)):
        if folders[idx] == "sequences":
            seqIdx= idx+1
    if (seqIdx == -1 or (seqIdx+2 > len(folders)) ):
        #not found, we exit as this job is not a scene in such a directory structure
        raise rrCleanExit()
    sequenceName=folders[seqIdx]
    shotName=  folders[seqIdx+1]
    if shotName.startswith(sequenceName):
        shotName= shotName[len(sequenceName)+1:]
    
    pos= sequenceName.find("_") # remove NTL_
    if pos>0:
        sequenceName= sequenceName[pos+1:]

    versionName= folders[len(folders)-1]
    if "_v" in versionName:
        pos= versionName.find("_v")+2
        versionName= versionName[pos:]
        pos= versionName.find(".") #remove extension
        versionName= versionName[0:pos] 
        pos= versionName.find("_") # remove _.... in case someone has added something after the version
        if pos>0:
            versionName= versionName[0:pos]
    else:
        versionName=""        


#remove this line for your final version
rrGlobal.writeLog(rrGlobal.logLvL.warning, "calcSeqShotVersion: "+sequenceName+" - "+shotName+" - "+versionName ,"")

#apply sequence/shot/version as calculated:
for jNr in range(0, rr.jobSelected_count()):
    job= rr.jobSelected_get(jNr)
    job.customSeqName= sequenceName
    job.customShotName= shotName
    job.customVersionName= versionName
    rr.jobSelected_set(jNr,job)
